<?php $__env->startSection('title', 'Divine Guidance & Vedic Wisdom - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>

<header class="bg-primary-50 py-24 text-center relative overflow-hidden">
    <div class="absolute top-0 left-0 w-64 h-64 bg-primary-100 rounded-full mix-blend-multiply filter blur-3xl opacity-30 -translate-x-1/2 -translate-y-1/2"></div>
    <div class="absolute bottom-0 right-0 w-96 h-96 bg-primary-200 rounded-full mix-blend-multiply filter blur-3xl opacity-20 translate-x-1/3 translate-y-1/3"></div>

    <div class="container mx-auto px-4 relative z-10">
        <h2 class="text-5xl md:text-7xl font-extrabold mb-6 text-gray-900 leading-tight">
            Divine Guidance for <br>
            <span class="text-primary-600">Modern Life</span>
        </h2>
        <p class="text-xl text-gray-600 mb-10 max-w-2xl mx-auto leading-relaxed">
            <?php echo e($site->meta_description ?? 'Unlock the ancient wisdom of Vedic Astrology, Vastu, and Sacred Rituals to navigate your life path with clarity.'); ?>

        </p>

        <div class="flex flex-col sm:flex-row justify-center gap-4">
            <a href="#services"
                class="bg-primary-600 text-white px-10 py-4 rounded-full font-bold text-lg hover:bg-primary-700 transition-all shadow-xl shadow-primary-200 hover:-translate-y-1">
                Explore Services
            </a>
            <a href="<?php echo e(route('horoscope.index')); ?>"
                class="bg-white text-primary-600 border-2 border-primary-600 px-10 py-4 rounded-full font-bold text-lg hover:bg-primary-50 transition-all">
                Daily Horoscope
            </a>
        </div>
    </div>
</header>

<section id="services" class="container mx-auto py-24 px-4">
    <div class="text-center mb-16">
        <h2 class="text-4xl font-extrabold text-gray-900 mb-4">Our Sacred Services</h2>
        <div class="w-24 h-1.5 bg-primary-500 mx-auto rounded-full"></div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white rounded-3xl shadow-sm hover:shadow-2xl transition-all duration-500 border border-gray-100 overflow-hidden group flex flex-col h-full">
            <div class="relative h-56 overflow-hidden">
                <img src="<?php echo e($service->image ? asset('storage/' . $service->image) : 'https://via.placeholder.com/600x400?text=' . urlencode($service->name)); ?>"
                    class="w-full h-full object-cover group-hover:scale-110 transition duration-700">

                <div class="absolute top-4 right-4 bg-white/95 backdrop-blur-sm px-4 py-1.5 rounded-full text-xs font-black uppercase tracking-widest text-primary-600 shadow-sm">
                    <?php echo e($service->category); ?>

                </div>
            </div>

            <div class="p-8 flex flex-col flex-grow">
                <h4 class="text-2xl font-bold text-gray-900 mb-3 group-hover:text-primary-600 transition-colors"><?php echo e($service->name); ?></h4>
                <p class="text-gray-500 leading-relaxed mb-8 flex-grow line-clamp-3 italic">
                    "<?php echo e(strip_tags($service->description)); ?>"
                </p>

                <div class="flex justify-between items-center pt-6 border-t border-gray-50 mt-auto">
                    <span class="text-2xl font-black text-gray-900">
                        <span class="text-sm font-normal text-gray-400 mr-1">NPR</span><?php echo e(number_format($service->price, 0)); ?>

                    </span>
                    <a href="<?php echo e(route('booking.create', ['service_id' => $service->id])); ?>"
                        class="bg-primary-50 text-primary-600 px-6 py-2 rounded-xl font-bold hover:bg-primary-600 hover:text-white transition-all flex items-center gap-2">
                        Book <span aria-hidden="true">&rarr;</span>
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <div class="text-center mt-16">
        <a href="<?php echo e(route('services.index')); ?>" class="group inline-flex items-center gap-3 text-gray-900 font-bold text-lg hover:text-primary-600 transition">
            View All Services
            <span class="w-10 h-10 rounded-full border-2 border-gray-200 flex items-center justify-center group-hover:border-primary-600 group-hover:translate-x-1 transition-all">&rarr;</span>
        </a>
    </div>
</section>

<section class="py-24 bg-primary-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-extrabold text-gray-900 mb-4">Meet Our Vedic Experts</h2>
            <div class="w-24 h-1.5 bg-primary-500 mx-auto rounded-full"></div>
            <p class="text-gray-600 mt-6 text-lg">Direct guidance from certified Masters of Astrology and Vastu.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $consultants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consultant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 group border border-white hover:border-primary-100">

                <div class="h-64 bg-primary-100 flex items-center justify-center overflow-hidden relative">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($consultant->image): ?>
                        <img src="<?php echo e(asset('storage/' . $consultant->image)); ?>"
                            alt="<?php echo e($consultant->user->name); ?>"
                            class="w-full h-full object-cover object-top group-hover:scale-105 transition duration-500">
                    <?php else: ?>
                        <div class="flex flex-col items-center">
                            <span class="text-6xl font-black text-primary-200">
                                <?php echo e(substr($consultant->user->name, 0, 1)); ?>

                            </span>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <div class="absolute bottom-0 left-0 w-full h-1/3 bg-gradient-to-t from-black/20 to-transparent"></div>
                </div>

                <div class="p-6 text-center">
                    <h3 class="text-xl font-bold text-gray-900"><?php echo e($consultant->user->name); ?></h3>
                    <p class="text-primary-600 font-bold text-sm uppercase tracking-widest mb-3"><?php echo e($consultant->specialization); ?></p>

                    <div class="flex justify-center items-center gap-1 text-yellow-400 text-sm mb-5 bg-gray-50 py-1 rounded-full w-fit mx-auto px-4">
                        <span>★</span><span>★</span><span>★</span><span>★</span><span>★</span>
                        <span class="text-gray-400 font-bold ml-1"><?php echo e(rand(45, 120)); ?>+</span>
                    </div>

                    <a href="<?php echo e(route('booking.create')); ?>">
                        <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-full justify-center']); ?>
                            Book Session
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                    </a>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center text-gray-500 bg-white/50 p-12 rounded-3xl border border-dashed border-primary-200">
                <p class="text-xl italic">Our spiritual council is currently gathering. Check back soon for new masters.</p>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</section>

<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-12 text-center">
            <div class="group">
                <div class="w-20 h-20 bg-primary-50 text-primary-600 rounded-2xl flex items-center justify-center mx-auto mb-6 text-3xl group-hover:bg-primary-600 group-hover:text-white transition-all duration-300 transform rotate-3 group-hover:rotate-0">
                    🔒
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">100% Private</h3>
                <p class="text-gray-500 leading-relaxed">Your birth data and consultations are held in sacred trust and remain strictly confidential.</p>
            </div>
            <div class="group">
                <div class="w-20 h-20 bg-primary-50 text-primary-600 rounded-2xl flex items-center justify-center mx-auto mb-6 text-3xl group-hover:bg-primary-600 group-hover:text-white transition-all duration-300 transform -rotate-3 group-hover:rotate-0">
                    📜
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Verified Lineage</h3>
                <p class="text-gray-500 leading-relaxed">Every master undergoes a rigorous vetting of their knowledge, lineage, and experience.</p>
            </div>
            <div class="group">
                <div class="w-20 h-20 bg-primary-50 text-primary-600 rounded-2xl flex items-center justify-center mx-auto mb-6 text-3xl group-hover:bg-primary-600 group-hover:text-white transition-all duration-300 transform rotate-3 group-hover:rotate-0">
                    🕉️
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Practical Remedies</h3>
                <p class="text-gray-500 leading-relaxed">We provide traditional Upays that are designed to fit effortlessly into your modern lifestyle.</p>
            </div>
        </div>
    </div>
</section>

<section class="py-24 bg-gray-900 text-white overflow-hidden relative">
    <div class="container mx-auto px-4 text-center relative z-10">
        <h2 class="text-4xl font-extrabold mb-16">Voice of the Devotees</h2>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white/5 backdrop-blur-sm p-10 rounded-3xl relative border border-white/10 text-left hover:bg-white/10 transition-colors group">
                <span class="absolute -top-6 left-10 text-8xl text-primary-600 font-serif opacity-30 group-hover:opacity-100 transition-opacity">“</span>
                <p class="text-gray-300 italic text-lg leading-relaxed mb-8 relative z-10">
                    <?php echo e($testimonial->message); ?>

                </p>

                <div class="flex flex-col gap-4 mt-auto">
                    <div class="flex items-center gap-1">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i=0; $i < $testimonial->rating; $i++): ?>
                            <span class="text-primary-500">★</span>
                        <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div class="font-bold text-xl text-primary-400">— <?php echo e($testimonial->user->name); ?></div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-gray-500 py-10">
                <p class="text-lg italic">The journey of a thousand testimonials begins with your first session.</p>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/welcome.blade.php ENDPATH**/ ?>