<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Booking Updated</title>
</head>
<body style="background-color:#f3f4f6;font-family:sans-serif;margin:0;padding:0;">
    <div style="max-width:580px;margin:0 auto;padding:20px;">
        <div style="background:#ffffff;border-radius:10px;overflow:hidden;border:1px solid #e5e7eb;">
            <div style="background:#111827;color:#fff;padding:18px;text-align:center;">
                <h2 style="margin:0;font-size:22px;">Booking Updated</h2>
                <p style="margin:6px 0 0 0;font-size:13px;opacity:.9;">
                    Reason: <?php echo e(ucfirst(str_replace('_', ' ', $reason))); ?>

                </p>
            </div>
            <div style="padding:22px;color:#111827;">
                <div style="background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;padding:14px;">
                    <p style="margin:0 0 8px 0;"><strong>Client:</strong> <?php echo e($booking->user->name); ?> (<?php echo e($booking->user->email); ?>)</p>
                    <p style="margin:0 0 8px 0;"><strong>Service:</strong> <?php echo e($booking->service->name); ?></p>
                    <p style="margin:0 0 8px 0;"><strong>Consultant:</strong> <?php echo e($booking->consultant->user->name); ?></p>
                    <p style="margin:0 0 8px 0;"><strong>Status:</strong> <?php echo e(ucfirst($booking->status)); ?></p>
                    <p style="margin:0;"><strong>Scheduled:</strong> <?php echo e(\Carbon\Carbon::parse($booking->scheduled_at)->format('M d, Y - h:i A')); ?></p>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($booking->meeting_link)): ?>
                    <p style="margin:14px 0 0 0;font-size:14px;">
                        <strong>Meeting link:</strong> <a href="<?php echo e($booking->meeting_link); ?>"><?php echo e($booking->meeting_link); ?></a>
                    </p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <p style="margin:16px 0 0 0;text-align:center;">
                    <a href="<?php echo e(url('/admin/bookings/'.$booking->id.'/edit')); ?>"
                       style="display:inline-block;background:#ea580c;color:#fff;text-decoration:none;padding:10px 16px;border-radius:8px;font-weight:700;">
                        Open in Admin
                    </a>
                </p>
            </div>
        </div>
    </div>
</body>
</html>

<?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/emails/admin_booking_update.blade.php ENDPATH**/ ?>