<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', $site->company_name ?? 'Vedic Platform'); ?></title>

    <meta name="description" content="<?php echo e($site->meta_description ?? ''); ?>">

    <link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>">

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="bg-slate-50 text-gray-800 flex flex-col min-h-screen font-sans antialiased">

    <nav class="bg-white shadow-sm sticky top-0 z-50" x-data="{ open: false }">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center h-20">
                <a href="/" class="flex items-center gap-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->logo) && $site->logo): ?>
                        <img src="<?php echo e(asset('storage/' . $site->logo)); ?>" class="h-12 w-auto" alt="Logo">
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <span
                        class="text-2xl font-bold text-primary-600 tracking-tight"><?php echo e($site->company_name ?? 'Vedic Platform'); ?></span>
                </a>

                <div class="hidden md:flex items-center space-x-8">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($menuItems)): ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->children->count() > 0): ?>
                                <div class="relative" x-data="{ open: false }" @mouseenter="open = true"
                                    @mouseleave="open = false">
                                    <button
                                        class="flex items-center font-medium hover:text-primary-600 transition gap-1 py-2">
                                        <?php echo e($item->label); ?>

                                        <svg class="w-4 h-4 transition-transform duration-200"
                                            :class="{ 'rotate-180': open }" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </button>
                                    <div x-show="open" x-transition class="absolute left-0 top-full pt-2 w-48 z-50">
                                        <div class="bg-white rounded-xl shadow-xl py-2 border border-gray-100">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e($child->url); ?>"
                                                    class="block px-4 py-2 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition">
                                                    <?php echo e($child->label); ?>

                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e($item->url); ?>" class="font-medium hover:text-primary-600 transition">
                                    <?php echo e($item->label); ?>

                                </a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('dashboard')); ?>"
                            class="bg-primary-600 text-white px-5 py-2 rounded-full font-bold hover:bg-primary-700 transition shadow-lg shadow-primary-200">
                            My Dashboard
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>"
                            class="bg-primary-600 text-white px-5 py-2 rounded-full font-bold hover:bg-primary-700 transition shadow-lg shadow-primary-200">
                            Login
                        </a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <button @click="open = !open" class="md:hidden text-gray-600 focus:outline-none">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <div x-show="open" class="md:hidden bg-white border-t p-4 space-y-4" style="display: none;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($menuItems)): ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->children->count() > 0): ?>
                        <div x-data="{ subOpen: false }">
                            <button @click="subOpen = !subOpen"
                                class="w-full flex justify-between items-center font-medium hover:text-primary-600">
                                <?php echo e($item->label); ?>

                                <svg class="w-4 h-4 transform transition" :class="{ 'rotate-180': subOpen }"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            <div x-show="subOpen" class="pl-4 mt-2 space-y-2 border-l-2 border-primary-100">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e($child->url); ?>"
                                        class="block text-gray-600 hover:text-primary-600"><?php echo e($child->label); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo e($item->url); ?>"
                            class="block font-medium hover:text-primary-600"><?php echo e($item->label); ?></a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('dashboard')); ?>" class="block text-primary-600 font-bold">My Dashboard</a>
            <?php else: ?>
                <a href="<?php echo e(route('login')); ?>" class="block text-primary-600 font-bold">Login</a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </nav>

    <main class="flex-grow">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer class="bg-gray-900 text-white pt-16 pb-8">
        <div class="container mx-auto px-4 grid grid-cols-1 md:grid-cols-3 gap-12">
            <div>
                <h4 class="text-xl font-bold mb-4 text-primary-400"><?php echo e($site->company_name ?? 'Vedic Platform'); ?></h4>
                <p class="text-gray-400 mb-4">
                    <?php echo e($site->meta_description ?? 'Authentic Vedic Astrology & Vastu Consultation Services.'); ?></p>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->contact_phone)): ?>
                    <p class="text-gray-300">📞 <?php echo e($site->contact_phone); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->contact_email)): ?>
                    <p class="text-gray-300">✉️ <?php echo e($site->contact_email); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <div>
                <h4 class="text-xl font-bold mb-4 text-primary-400">Quick Links</h4>
                <ul class="space-y-2 text-gray-400">
                    <li><a href="<?php echo e(route('services.index')); ?>" class="hover:text-white">Our Services</a></li>
                    <li><a href="<?php echo e(route('blog.index')); ?>" class="hover:text-white">Articles & Wisdom</a></li>
                    <li><a href="/admin/login" class="hover:text-white">Consultant Login</a></li>
                    <li><a href="<?php echo e(route('privacy')); ?>" class="hover:text-white transition">Privacy Policy</a></li>
                    <li><a href="<?php echo e(route('terms')); ?>" class="hover:text-white transition">Terms & Conditions</a></li>
                </ul>
            </div>

            <div>
                <h4 class="text-xl font-bold mb-4 text-primary-400">Connect</h4>
                <div class="flex space-x-4">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->facebook_url)): ?>
                        <a href="<?php echo e($site->facebook_url); ?>" class="hover:text-primary-400">Facebook</a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->instagram_url)): ?>
                        <a href="<?php echo e($site->instagram_url); ?>" class="hover:text-primary-400">Instagram</a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->youtube_url)): ?>
                        <a href="<?php echo e($site->youtube_url); ?>" class="hover:text-primary-400">YouTube</a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>

        <div class="border-t border-gray-800 mt-12 pt-8 text-center text-gray-500 text-sm">
            &copy; <?php echo e(date('Y')); ?> <?php echo e($site->company_name ?? 'Vedic Platform'); ?>. All rights reserved.
        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/layouts/frontend.blade.php ENDPATH**/ ?>