<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Booking Request Received</title>
</head>
<body style="background-color:#f3f4f6;font-family:sans-serif;margin:0;padding:0;">
    <div style="max-width:580px;margin:0 auto;padding:20px;">
        <div style="background:#ffffff;border-radius:10px;overflow:hidden;border:1px solid #e5e7eb;">
            <div style="background:#ea580c;color:#fff;padding:18px;text-align:center;">
                <h2 style="margin:0;font-size:22px;">Booking Request Received ✅</h2>
            </div>
            <div style="padding:22px;color:#111827;">
                <p style="margin:0 0 12px 0;font-size:16px;">Namaste <?php echo e($booking->user->name); ?>,</p>
                <p style="margin:0 0 16px 0;font-size:15px;color:#374151;">
                    We received your booking request. Our team will verify your payment and confirm your consultation soon.
                </p>

                <div style="background:#fff7ed;border:1px solid #ffedd5;border-radius:8px;padding:14px;">
                    <p style="margin:0 0 8px 0;"><strong>Service:</strong> <?php echo e($booking->service->name); ?></p>
                    <p style="margin:0 0 8px 0;"><strong>Consultant:</strong> <?php echo e($booking->consultant->user->name); ?></p>
                    <p style="margin:0;"><strong>Requested Time:</strong> <?php echo e(\Carbon\Carbon::parse($booking->scheduled_at)->format('M d, Y - h:i A')); ?></p>
                </div>

                <p style="margin:16px 0 0 0;font-size:13px;color:#6b7280;">
                    You can reschedule or cancel while the status is pending from your dashboard.
                </p>
            </div>
        </div>
    </div>
</body>
</html>

<?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/emails/user_booking_requested.blade.php ENDPATH**/ ?>