<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HoroscopeController;
use App\Http\Controllers\RegistrationController;
use App\Http\Controllers\FrontendServiceController; // <--- Import the new controller


Route::get('/', [HomeController::class, 'index'])->name('home');
// Contact Form Route
// Change the previous Route::view to this:
Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');

//private policy and terms of service
Route::view('/privacy-policy','legal.privacy')->name('privacy');
Route::view('/terms-and-conditions', 'legal.terms')->name('terms');

//view about page
Route::view('/about', 'about')->name('about');

// Add this name('login') route so the 'auth' middleware knows where to go
// DELETE OR COMMENT THIS OLD CODE:
// Route::get('/login', function () {
//     return redirect()->route('filament.admin.auth.login');
// })->name('login');

// Public Service Routes
Route::get('/services', [FrontendServiceController::class, 'index'])->name('services.index');
// Route::get('/services/{slug}', [FrontendServiceController::class, 'show'])->name('services.show');

// Public Auth Routes
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');

// Registration Routes
Route::get('/register', [RegistrationController::class, 'create'])->name('register');
Route::post('/register', [RegistrationController::class, 'store'])->name('register.store');

// Horoscope Section
Route::get('/horoscopes', [HoroscopeController::class, 'index'])->name('horoscope.index');
Route::get('/horoscopes/{sign}', [HoroscopeController::class, 'show'])->name('horoscope.show');

// The Public Blog
Route::get('/blog', [BlogController::class, 'index'])->name('blog.index');
Route::get('/articles/{slug}', [BlogController::class, 'show'])->name('blog.show');

// Protected User Routes
Route::middleware(['auth'])->group(function () {

    // The Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Booking Routes
    Route::get('/book', [BookingController::class, 'create'])->name('booking.create');
    Route::post('/book', [BookingController::class, 'store'])->name('booking.store');
    Route::get('/bookings/slots', [BookingController::class, 'availableSlots'])->name('booking.slots');
    Route::get('/bookings/{booking}/reschedule', [BookingController::class, 'editSchedule'])->name('booking.reschedule.edit');
    Route::patch('/bookings/{booking}/reschedule', [BookingController::class, 'updateSchedule'])->name('booking.reschedule.update');
    Route::patch('/bookings/{booking}/cancel', [BookingController::class, 'cancel'])->name('booking.cancel');

    // Logout Route (Filament usually handles login, but we need a logout for frontend)
    Route::post('/logout', function () {
        auth()->logout();
        request()->session()->invalidate();
        request()->session()->regenerateToken();
        return redirect('/');
    })->name('logout');

    // Profile Routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');
});

// Testimonial Routes
Route::post('/testimonials', function (\Illuminate\Http\Request $request) {
    $request->validate([
        'message' => 'required|string|max:500',
        'rating' => 'required|integer|min:1|max:5',
    ]);

    \App\Models\Testimonial::create([
        'user_id' => auth()->id(),
        'message' => $request->message,
        'rating' => $request->rating,
        'is_active' => false, // Pending Admin Approval
    ]);

    return back()->with('success', 'Thank you! Your review has been submitted for approval.');
})->middleware(['auth'])->name('testimonials.store');
