@extends('layouts.frontend')

@section('title', 'Home - ' . $site->company_name)

@section('content')

    <header class="bg-orange-50 py-20 text-center relative overflow-hidden">
        <div class="container mx-auto px-4 relative z-10">
            <h2 class="text-4xl md:text-6xl font-extrabold mb-6 text-gray-900">Divine Guidance for <span
                    class="text-orange-600">Modern Life</span></h2>
            <p class="text-lg text-gray-600 mb-8 max-w-2xl mx-auto">
                {{ $site->meta_description ?? 'Expert Vedic Astrology, Vastu Consulting, and Spiritual Rituals.' }}</p>
            <a href="#services"
                class="bg-orange-600 text-white px-8 py-3 rounded-full font-bold text-lg hover:bg-orange-700 transition shadow-xl shadow-orange-200">
                Explore Services
            </a>
        </div>
    </header>

    <section id="services" class="container mx-auto py-20 px-4">
        <div class="text-center mb-16">
            <h3 class="text-3xl font-bold text-gray-900">Our Sacred Services</h3>
            <div class="w-24 h-1 bg-orange-500 mx-auto mt-4 rounded-full"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @foreach ($services as $service)
                <div class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition duration-300 border border-gray-100 overflow-hidden group">
                    <div class="relative h-48 overflow-hidden">
                        <img src="{{ $service->image ? asset('storage/' . $service->image) : 'https://via.placeholder.com/400x250?text=Service' }}"
                            class="w-full h-full object-cover group-hover:scale-105 transition duration-500">
                        <div class="absolute top-4 right-4 bg-white/90 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider text-orange-600">
                            {{ $service->category }}
                        </div>
                    </div>

                    <div class="p-8">
                        <h4 class="text-xl font-bold text-gray-900 mb-3">{{ $service->name }}</h4>
                        <p class="text-gray-500 text-sm line-clamp-3 mb-6">{{ strip_tags($service->description) }}</p>

                        <div class="flex justify-between items-center pt-6 border-t border-gray-100">
                            <span class="text-lg font-bold text-gray-900">NPR {{ number_format($service->price, 0) }}</span>
                            <a href="{{ route('booking.create', ['service_id' => $service->id]) }}"
                                class="text-orange-600 font-bold hover:text-orange-700 flex items-center gap-2">
                                Book Now <span aria-hidden="true">&rarr;</span>
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="text-center mt-12">
            <a href="{{ route('services.index') }}" class="inline-block border-2 border-gray-800 text-gray-800 px-8 py-2 rounded-full font-bold hover:bg-gray-800 hover:text-white transition">
                View All Services
            </a>
        </div>
    </section>

    <section class="py-16 bg-orange-50">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-800">Meet Our Vedic Experts</h2>
                <div class="w-24 h-1 bg-orange-500 mx-auto mt-4 rounded-full"></div>
                <p class="text-gray-600 mt-4">Guidance from certified and experienced professionals.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                @forelse($consultants as $consultant)
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                        <div class="h-48 bg-orange-100 flex items-center justify-center">
                            <span class="text-5xl font-bold text-orange-300">{{ substr($consultant->user->name, 0, 1) }}</span>
                        </div>

                        <div class="p-6 text-center">
                            <h3 class="text-xl font-bold text-gray-800">{{ $consultant->user->name }}</h3>
                            <p class="text-orange-600 font-medium text-sm mb-2">{{ $consultant->specialization }}</p>

                            <div class="flex justify-center items-center gap-1 text-yellow-400 text-sm mb-4">
                                <span>★</span><span>★</span><span>★</span><span>★</span><span>★</span>
                                <span class="text-gray-400 ml-1">({{ rand(20, 100) }} reviews)</span>
                            </div>

                            <p class="text-gray-500 text-sm line-clamp-2 mb-4">
                                Expert in {{ $consultant->specialization }} with over {{ rand(5, 15) }} years of experience.
                            </p>

                            <a href="{{ route('booking.create') }}" class="block w-full py-2 border-2 border-orange-600 text-orange-600 font-bold rounded-lg hover:bg-orange-600 hover:text-white transition">
                                Book Consultation
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="col-span-4 text-center text-gray-500 bg-white p-8 rounded-xl border border-dashed border-gray-300">
                        <p>Our astrologers are currently being updated. Please check back soon!</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>

    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
                <div class="p-6">
                    <div class="w-16 h-16 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl">
                        🔒
                    </div>
                    <h3 class="text-lg font-bold text-gray-800 mb-2">100% Private</h3>
                    <p class="text-gray-500 text-sm">Your birth details and conversations are kept strictly confidential.</p>
                </div>
                <div class="p-6">
                    <div class="w-16 h-16 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl">
                        📜
                    </div>
                    <h3 class="text-lg font-bold text-gray-800 mb-2">Verified Experts</h3>
                    <p class="text-gray-500 text-sm">Every astrologer passes a rigorous testing process before joining.</p>
                </div>
                <div class="p-6">
                    <div class="w-16 h-16 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl">
                        🕉️
                    </div>
                    <h3 class="text-lg font-bold text-gray-800 mb-2">Authentic Remedies</h3>
                    <p class="text-gray-500 text-sm">Practical and traditional remedies (Upay) that are easy to follow.</p>
                </div>
            </div>
        </div>
    </section>

   <section class="py-16 bg-gray-900 text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl font-bold mb-12">What Our Devotees Say</h2>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @forelse($testimonials as $testimonial)
                <div class="bg-gray-800 p-8 rounded-xl relative">
                    <span class="absolute top-4 left-6 text-6xl text-orange-600 opacity-20">"</span>
                    <p class="text-gray-300 italic mb-6">"{{ $testimonial->message }}"</p>

                    <div class="flex items-center justify-center gap-2 mb-2">
                        @for($i=0; $i < $testimonial->rating; $i++)
                            <span class="text-yellow-400">★</span>
                        @endfor
                    </div>

                    <div class="font-bold text-orange-500">- {{ $testimonial->user->name }}</div>
                </div>
            @empty
                <div class="col-span-3 text-gray-500 italic">
                    No reviews yet. Be the first to share your experience!
                </div>
            @endforelse
        </div>
    </div>
</section>

@endsection
