<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>New Booking Request</title>
    <style>
        /* Responsive adjustments for mobile */
        @media only screen and (max-width: 620px) {
            table.body h1 { font-size: 28px !important; margin-bottom: 10px !important; }
            table.body p, table.body ul, table.body ol, table.body td, table.body span, table.body a { font-size: 16px !important; }
            table.body .wrapper, table.body .article { padding: 10px !important; }
            table.body .content { padding: 0 !important; }
            table.body .container { padding: 0 !important; width: 100% !important; }
        }
    </style>
</head>
<body style="background-color: #f3f4f6; font-family: sans-serif; -webkit-font-smoothing: antialiased; font-size: 14px; line-height: 1.4; margin: 0; padding: 0; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;">
    <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; background-color: #f3f4f6;">
        <tr>
            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top;">&nbsp;</td>
            <td class="container" style="font-family: sans-serif; font-size: 14px; vertical-align: top; display: block; max-width: 580px; padding: 10px; width: 580px; margin: 0 auto;">
                <div class="content" style="box-sizing: border-box; display: block; margin: 0 auto; max-width: 580px; padding: 10px;">

                    <table role="presentation" class="main" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; background: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">

                        <tr>
                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; background-color: #ea580c; padding: 20px; text-align: center;">
                                <h2 style="color: #ffffff; font-family: sans-serif; font-weight: bold; line-height: 1.4; margin: 0; font-size: 24px;">New Booking Received</h2>
                            </td>
                        </tr>

                        <tr>
                            <td class="wrapper" style="font-family: sans-serif; font-size: 14px; vertical-align: top; box-sizing: border-box; padding: 30px;">
                                <p style="font-family: sans-serif; font-size: 16px; font-weight: normal; margin: 0; margin-bottom: 15px;">Hello Admin,</p>
                                <p style="font-family: sans-serif; font-size: 16px; font-weight: normal; margin: 0; margin-bottom: 15px;">
                                    A new consultation request requires your attention.
                                </p>

                                <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; background-color: #fff7ed; border-radius: 6px; padding: 15px; margin-bottom: 20px; border: 1px solid #ffedd5;">
                                    <tbody>
                                        <tr>
                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding: 5px 0;">
                                                <strong>Client:</strong> {{ $booking->user->name }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding: 5px 0;">
                                                <strong>Email:</strong> <a href="mailto:{{ $booking->user->email }}" style="color: #ea580c; text-decoration: none;">{{ $booking->user->email }}</a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding: 5px 0;">
                                                <strong>Service:</strong> {{ $booking->service->name }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding: 5px 0;">
                                                <strong>Consultant:</strong> {{ $booking->consultant->user->name }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding: 5px 0;">
                                                <strong>Scheduled Date:</strong> {{ \Carbon\Carbon::parse($booking->scheduled_at)->format('M d, Y - h:i A') }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                <table role="presentation" border="0" cellpadding="0" cellspacing="0" class="btn btn-primary" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; box-sizing: border-box;">
                                    <tbody>
                                        <tr>
                                            <td align="center" style="font-family: sans-serif; font-size: 14px; vertical-align: top; padding-bottom: 15px;">
                                                <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: auto;">
                                                    <tbody>
                                                        <tr>
                                                            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top; background-color: #ea580c; border-radius: 5px; text-align: center;">
                                                                <a href="{{ url('/admin/bookings/'.$booking->id.'/edit') }}" target="_blank" style="display: inline-block; color: #ffffff; background-color: #ea580c; border: solid 1px #ea580c; border-radius: 5px; box-sizing: border-box; cursor: pointer; text-decoration: none; font-size: 16px; font-weight: bold; margin: 0; padding: 12px 25px; text-transform: capitalize; border-color: #ea580c;">
                                                                    Review & Approve
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <p style="font-family: sans-serif; font-size: 14px; font-weight: normal; margin: 0; margin-bottom: 15px; color: #6b7280; text-align: center;">
                                    Please login to the admin panel to verify payment.
                                </p>
                            </td>
                        </tr>
                    </table>
                    <div class="footer" style="clear: both; margin-top: 10px; text-align: center; width: 100%;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%;">
                            <tr>
                                <td class="content-block" style="font-family: sans-serif; vertical-align: top; padding-bottom: 10px; padding-top: 10px; font-size: 12px; color: #999999; text-align: center;">
                                    <span class="apple-link" style="color: #999999; font-size: 12px; text-align: center;">Vedic Astro Company, Kathmandu, Nepal</span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    </div>
            </td>
            <td style="font-family: sans-serif; font-size: 14px; vertical-align: top;">&nbsp;</td>
        </tr>
    </table>
</body>
</html>
