@extends('layouts.frontend')

@section('title', 'Login - ' . $site->company_name)

@section('content')
    <div class="min-h-screen flex items-center justify-center bg-primary-50 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 bg-white p-10 rounded-2xl shadow-xl">
            <div class="text-center">
                <h2 class="mt-6 text-3xl font-extrabold text-gray-900">Welcome Back</h2>
                <p class="mt-2 text-sm text-gray-600">
                    Sign in to manage your bookings and profile
                </p>
            </div>

            <form class="mt-8 space-y-6" action="{{ route('login.submit') }}" method="POST">
                @csrf
                <div class="rounded-md shadow-sm -space-y-px">
                    <div class="mb-4">
                        <label for="email" class="sr-only">Email address</label>
                        <input id="email" name="email" type="email" required
                            class="appearance-none rounded-lg relative block w-full px-3 py-3 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-primary-500 focus:border-primary-500 focus:z-10 sm:text-sm"
                            placeholder="Email address">
                    </div>
                    <div>
                        <label for="password" class="sr-only">Password</label>
                        <input id="password" name="password" type="password" required
                            class="appearance-none rounded-lg relative block w-full px-3 py-3 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-primary-500 focus:border-primary-500 focus:z-10 sm:text-sm"
                            placeholder="Password">
                    </div>
                </div>

                @if ($errors->any())
                    <div class="text-red-500 text-sm text-center">
                        {{ $errors->first() }}
                    </div>
                @endif

                <div>
                    <x-primary-button class="w-full justify-center py-3 text-sm">
                        Sign in
                    </x-primary-button>
                </div>

                <div class="text-center mt-6">
                    <p class="text-sm text-gray-600">
                        Don't have an account?
                        <a href="{{ route('register') }}" class="font-bold text-primary-600 hover:text-primary-800">
                            Create one now
                        </a>
                    </p>
                </div>

                <div class="text-center mt-4">
                    <a href="/" class="text-sm text-gray-500 hover:text-primary-600">Back to Home</a>
                </div>
            </form>
        </div>
    </div>
@endsection
