<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('astrology_profiles', function (Blueprint $table) {
            // We use 'json' type to store the planet array efficiently
        // 'nullable' because new users won't have data yet
        $table->json('chart_data')->nullable()->after('pob');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('astrology_profiles', function (Blueprint $table) {
           $table->dropColumn('chart_data');
        });
    }
};
