<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('navigation_items', function (Blueprint $table) {
            $table->id();
            $table->string('label'); // e.g., "Services"
            $table->string('url')->nullable(); // e.g., "/services"
            $table->foreignId('parent_id')->nullable()->constrained('navigation_items')->cascadeOnDelete(); // For dropdowns
            $table->integer('order')->default(0); // To sort 1st, 2nd, 3rd
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('navigation_items');
    }
};
