<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('horoscopes', function (Blueprint $table) {
            $table->id();
            $table->enum('zodiac_sign', [
                'aries',
                'taurus',
                'gemini',
                'cancer',
                'leo',
                'virgo',
                'libra',
                'scorpio',
                'sagittarius',
                'capricorn',
                'aquarius',
                'pisces'
            ]);
            $table->enum('type', ['daily', 'weekly', 'monthly', 'yearly']);
            $table->date('valid_from'); // Start date (e.g., Today, or Jan 1st)
            $table->date('valid_to');   // End date (e.g., Today, or Dec 31st)
            $table->text('prediction');
            $table->integer('lucky_number')->nullable();
            $table->string('lucky_color')->nullable();
            $table->timestamps();

            // Index for fast lookup (Very important for daily traffic)
            $table->index(['zodiac_sign', 'type', 'valid_from']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('horoscopes');
    }
};
