<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->onDelete('cascade');
            $table->string('transaction_id')->unique(); // ID from eSewa/Khalti
            $table->decimal('amount', 10, 2);
            $table->string('payment_method'); // e.g., "esewa", "khalti"
            $table->enum('payment_status', ['pending', 'success', 'failed', 'refunded']);
            $table->json('payload')->nullable(); // Store full response from gateway for debugging
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
