<?php

namespace App\Models;

use Filament\Models\Contracts\FilamentUser;
use Filament\Panel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements FilamentUser
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    /**
     * Filament Panel Access Logic
     */
    public function canAccessPanel(Panel $panel): bool
    {

        // Only allow Admins and Consultants (Panel Users) to access the /admin area
        return $this->hasRole(['super_admin', 'consultant']);
        // While developing, return true.
        // In production, use: return $this->hasRole('super_admin');
        return true;
    }

    /**
     * Relationships
     */
    public function astrologyProfile()
    {
        return $this->hasOne(AstrologyProfile::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }

    public function consultant()
    {
        return $this->hasOne(Consultant::class);
    }
}
