<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Consultant extends Model
{
    /** @use HasFactory<\Database\Factories\ConsultantFactory> */
    use HasFactory;
    protected $fillable = [
        'user_id',
        'bio',
        'specialization',
        'experience_years',
        'languages',
        'rating',
        'is_available',
        'image', // <--- Add this line
    ];

    // Add this part
    protected $casts = [
        'languages' => 'array',
        'rating' => 'float', // Helps ensure it treats the DB decimal as a number
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
