<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class RegistrationController extends Controller
{
    // Show the Sign Up Form
    public function create()
    {
        return view('auth.register');
    }

    // Process the Registration
    public function store(Request $request)
    {
        // 1. Validate
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed', // expects 'password_confirmation' field
        ]);

        // 2. Create User
        $user = User::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'password' => Hash::make($validated['password']),
        ]);

        // 3. Auto-Login
        Auth::login($user);

        // 4. Redirect
        // If they tried to book a service before logging in, 'intended' sends them back to the booking page!
        return redirect()->intended('/dashboard');
    }
}
