<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;

class FrontendServiceController extends Controller
{
    public function index()
    {
        // Fetch ALL active services for the public catalog
        $services = Service::where('is_active', true)
                    ->orderBy('category')
                    ->get();

        // Return the view we created in the previous step
        return view('services.index', compact('services'));
    }

    public function show($slug)
    {
        $service = Service::where('slug', $slug)->where('is_active', true)->firstOrFail();
        return view('services.show', compact('service'));
    }
}
