<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Mail\AdminContactNotification;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{

    public function index()
    {
        return view('contact');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required',
        ]);

        // \App\Models\ContactMessage::create($data);
        // FIX: Assign the created model to the variable $contactMessage
        $contactMessage = \App\Models\ContactMessage::create($data);

        // 2. Send Real-time Email Alert to Admin
        $adminEmail = config('mail.from.address'); // Or use $site->contact_email
        Mail::to($adminEmail)->send(new AdminContactNotification($contactMessage));

        return back()->with('success', 'Your message has been sent successfully!');
    }
}
