<?php

namespace App\Filament\Resources;

use App\Filament\Resources\HoroscopeResource\Pages;
use App\Filament\Resources\HoroscopeResource\RelationManagers;
use App\Models\Horoscope;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class HoroscopeResource extends Resource
{
    protected static ?string $model = Horoscope::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // In form() schema:
                Forms\Components\Grid::make(3)->schema([
                    Forms\Components\Select::make('zodiac_sign')
                        ->options([
                            'aries' => 'Aries (Mesha)',
                            'taurus' => 'Taurus (Vrishabha)',
                            'gemini' => 'Gemini (Mithuna)',
                            'cancer' => 'Cancer (Karka)',
                            'leo' => 'Leo (Simha)',
                            'virgo' => 'Virgo (Kanya)',
                            'libra' => 'Libra (Tula)',
                            'scorpio' => 'Scorpio (Vrishchika)',
                            'sagittarius' => 'Sagittarius (Dhanu)',
                            'capricorn' => 'Capricorn (Makara)',
                            'aquarius' => 'Aquarius (Kumbha)',
                            'pisces' => 'Pisces (Meena)',
                        ])->required(),

                    Forms\Components\Select::make('type')
                        ->options([
                            'daily' => 'Daily',
                            'weekly' => 'Weekly',
                            'monthly' => 'Monthly',
                            'yearly' => 'Yearly',
                        ])->required(),

                    Forms\Components\DatePicker::make('valid_from')->required(),
                    Forms\Components\DatePicker::make('valid_to')->required(),

                    Forms\Components\Textarea::make('prediction')->rows(4)->columnSpanFull(),

                    Forms\Components\TextInput::make('lucky_number')->numeric(),
                    Forms\Components\TextInput::make('lucky_color'),
                    Forms\Components\Textarea::make('love')->rows(4)->columnSpanFull(),
                    Forms\Components\Textarea::make('career')->rows(4)->columnSpanFull(),
                    Forms\Components\Textarea::make('finance')->rows(4)->columnSpanFull(),
                    Forms\Components\Textarea::make('health')->rows(4)->columnSpanFull(),
                ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('zodiac_sign'),
                Tables\Columns\TextColumn::make('type'),
                Tables\Columns\TextColumn::make('valid_from')
                    ->date()
                    ->sortable(),
                Tables\Columns\TextColumn::make('valid_to')
                    ->date()
                    ->sortable(),
                Tables\Columns\TextColumn::make('lucky_number')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('lucky_color')
                    ->searchable(),
                Tables\Columns\TextColumn::make('love')
                    ->searchable(),
                Tables\Columns\TextColumn::make('career')
                    ->searchable(),
                Tables\Columns\TextColumn::make('finance')
                    ->searchable(),
                Tables\Columns\TextColumn::make('health')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListHoroscopes::route('/'),
            'create' => Pages\CreateHoroscope::route('/create'),
            'edit' => Pages\EditHoroscope::route('/{record}/edit'),
        ];
    }
}
