## Vedic Platform (SaaS)

Multi-tenant-ready starter for a **Vedic Astrology / Vastu / Karmakanda** service platform built with **Laravel** + **Filament**.

### Features

- **Frontend**
  - Services catalog + booking flow
  - Daily horoscope (12 signs) + horoscope detail sections (love/career/finance/health)
  - Blog pages
  - User dashboard (bookings, kundali view, testimonials)
- **Bookings**
  - Manual payment with **QR + bank details** configurable from admin
  - Upload payment proof screenshot
  - Prevents double booking (same consultant + same slot for pending/confirmed)
  - **Available slots API** so users select only valid times
  - Client can **reschedule/cancel** while booking is pending
- **Admin (Filament)**
  - Manage company settings (branding, contact, SEO, legal, payment details)
  - Manage services, consultants, horoscopes, bookings, etc.
- **Email**
  - Sends emails to **admin + client**
  - Queue-enabled mailables (database queue)

### Tech stack

- **Backend**: Laravel (PHP)
- **Admin**: Filament
- **UI**: Blade + Tailwind (Vite)
- **Permissions**: Spatie Roles/Permissions
- **Queue**: database driver

---

## Requirements

- PHP + Composer
- Node.js + npm
- MySQL (XAMPP is fine)

---

## Setup (local)

### 1) Install dependencies

```bash
composer install
npm install
```

### 2) Configure environment

```bash
copy .env.example .env
php artisan key:generate
```

Update your `.env` for DB + mail + timezone, for example:

- **DB**: `DB_HOST`, `DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`
- **Timezone**: `APP_TIMEZONE=Asia/Kathmandu`
- **Queue**: `QUEUE_CONNECTION=database`
- **Mail**: `MAIL_MAILER=smtp` + your SMTP settings

Important: `config/app.php` should use `env('APP_TIMEZONE', 'UTC')` for timezone.

### 3) Migrate + seed demo data

This project includes a SaaS-friendly seeder that creates roles, admin user, consultants, services, nav menu, company settings, and a demo horoscope.

Optional `.env` overrides:

```env
VEDIC_SEED_ADMIN_EMAIL=admin@vedic.com
VEDIC_SEED_ADMIN_PASSWORD=password
VEDIC_SEED_CONSULTANT_PASSWORD=password
```

Run:

```bash
php artisan migrate --seed --seeder=Database\\Seeders\\VedicPlatformSeeder
php artisan storage:link
```

### 4) Run the app

Terminal A:

```bash
php artisan serve
```

Terminal B:

```bash
npm run dev
```

---

## Queue worker (email queueing)

Mail is queue-enabled. Run a worker in another terminal:

```bash
php artisan queue:work --tries=3
```

---

## Admin panel

- **URL**: `/admin`
- **Default super admin**: from `VEDIC_SEED_ADMIN_EMAIL` / `VEDIC_SEED_ADMIN_PASSWORD`

### Configure payment (QR/bank) for booking

Admin → **Company Settings** → **Payment Details**

- `payment_qr_image`
- `payment_bank_name`
- `payment_account_number`
- `payment_account_name`
- `payment_instructions`

---

## Booking schedule rules

- Slots are generated by default for **09:00–18:00** in **30 minute** intervals.
- Bookings are blocked if the same consultant already has a **pending/confirmed** booking at the same time.
- Client can reschedule/cancel only while booking is **pending**.

To change slot rules, update constants in `app/Http/Controllers/BookingController.php`.

---

## Notes for SaaS reuse

- `VedicPlatformSeeder` is designed to be **idempotent** (safe to run multiple times).
- Company settings are seeded with row `id=1` and shared to Blade as `$site`.

